﻿namespace Microsoft.Samples.PlanMyNight.Web
{
    using System;
    using System.Globalization;

    public static class TimeHelper
    {
        public static string GetFriendlyTime(int totalMinutes)
        {
            if (totalMinutes > 0)
            {
                int hours = totalMinutes / 60;
                int minutes = totalMinutes % 60;
                string time = string.Empty;
                if (hours > 0)
                {
                    time += string.Format(CultureInfo.InvariantCulture, "{0}h ", hours);
                }

                if (minutes > 0)
                {
                    time += string.Format(CultureInfo.InvariantCulture, "{0}m", minutes);
                }

                return time.Trim();
            }

            return "-";
        }
    }

    public static class ItineraryHelper
    {
        public static string GetRatingLabel(decimal? rating)
        {
            return (Math.Round((rating ?? 0) * 2) / 2).ToString("0.0", CultureInfo.InvariantCulture);
        }

        public static string GetRatingCssClass(decimal? rating)
        {
            return "rating_" + GetRatingLabel(rating).Replace('.', '_');
        }
    }

    public static class ActivityHelper
    {
        public static string GetRatingLabel(double rating)
        {
            return Math.Round(rating / 2).ToString("0.0", CultureInfo.InvariantCulture);
        }

        public static string GetRatingCssClass(double rating)
        {
            return "rating_" + GetRatingLabel(rating).Replace('.', '_');
        }
    }
}